#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Installing:
# python.exe -m pip install --upgrade pip Collecting pip
# pip install -U pymodbus
# pip install requests
# pip install idna
# https://pymodbustcp.readthedocs.io/en/latest/quickstart/index.html#
#
#
# Modbus Software to read Coils and Inputs from openplcproject 
# with Raspberry PI
# Data are sent to Webserver via http post request
#
#   pytohon 3 with modbus library
#
#   Josef Bernhardt Bad Abbach 6.3.2021  josef@bernhardt.de
#
from pyModbusTCP.client import ModbusClient
import time
import requests


s1 = "Teststring Input"

count = 0

# Webserver at Strato
url = 'http://www.bernhardt.de/modbus/sqlabfrage.php'

#aktion=write&file=messwerte.csv&inhalt=Test

# Modbus Server PLC Software at Raspberry PI or ESP8266 with Modbus
SERVER_HOST = "192.168.178.89"
SERVER_PORT = 502
SERVER_U_ID = 1

c = ModbusClient()

# uncomment this line to see debug message
# c.debug(True)

# define modbus server host, port and unit_id
c.host(SERVER_HOST)
c.port(SERVER_PORT)
c.unit_id(SERVER_U_ID)

while True:
    # Data for File outputs.csv
    sq = "1.99"
    # Data for File inputs.csv
    si = "5.55"
    
    # open or reconnect TCP to modbus server
    if not c.is_open():
        if not c.open():
            print("unable to connect to "+SERVER_HOST+":"+str(SERVER_PORT))

    # if open() is ok, read coils (modbus function 0x01)
    if c.is_open():
        # read 8 bits at address 0, store result in regs list
        bits = c.read_coils(0, 8)
        # if success display registers
        if bits:
            #print("Coils at #0 to 7: "+str(bits))
            #s1 = str(bits)
            if bits[0] == 1:
                sq = sq + ";1"
            else:
                sq = sq + ";0"
            if bits[1] == 1:
                sq = sq + ";1"
            else:
                sq = sq + ";0"
            if bits[2] == 1:
                sq = sq + ";1"
            else:
                sq = sq + ";0"
            if bits[3] == 1:
                sq = sq + ";1"
            else:
                sq = sq + ";0"
            if bits[4] == 1:
                sq = sq + ";1"
            else:
                sq = sq + ";0"
            if bits[5] == 1:
                sq = sq + ";1"
            else:
                sq = sq + ";0"
            if bits[6] == 1:
                sq = sq + ";1"
            else:
                sq = sq + ";0"
            if bits[7] == 1:
                sq = sq + ";1"
            else:
                sq = sq + ";0"
 
        print (sq)

        dataout = {'aktion':'write','file':'outputs.csv' ,'inhalt': sq }
        try:
            r = requests.post(url , dataout)
            print(r.text)
        except:
            print("Post Error")
        
        
        time.sleep(0.2)
 
         # read 8 bits at address 0, store result in regs list
        bits = c.read_discrete_inputs(0, 8)
        # if success display registers
        if bits:
            #print("Inputs ad #0 to 7: "+str(bits))   
            #s1 = str(bits)
            if bits[0] == 1:
                si = si + ";1"
            else:
                si = si + ";0"
            if bits[1] == 1:
                si = si + ";1"
            else:
                si = si + ";0"
            if bits[2] == 1:
                si = si + ";1"
            else:
                si = si + ";0"
            if bits[3] == 1:
                si = si + ";1"
            else:
                si = si + ";0"
            if bits[4] == 1:
                si = si + ";1"
            else:
                si = si + ";0"
            if bits[5] == 1:
                si = si + ";1"
            else:
                si = si + ";0"
            if bits[6] == 1:
                si = si + ";1"
            else:
                si = si + ";0"
            if bits[7] == 1:
                si = si + ";1"
            else:
                si = si + ";0"
 
        print (si)


        # Send Data to Webserver
        datain = {'aktion':'write','file':'inputs.csv' ,'inhalt':si}
        try:
            r = requests.post(url , datain)
            print(r.text)
        except:
            print ("Post Error")
 
        # Read input Values from PLC

"""
        regs = c.read_holding_registers(0, 8)
        # if success display registers
        if regs:
            print("reg ad #0 to 7: "+str(regs))
""" 
     
        # sleep 0.2 s before next polling
time.sleep(0.2)
